/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.util.ChunkCapData;
import com.minecolonies.coremod.util.ChunkClientDataHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateChunkCapabilityMessage
implements IMessage {
    private ChunkCapData chunkCapData;

    public UpdateChunkCapabilityMessage() {
    }

    public UpdateChunkCapabilityMessage(@NotNull IColonyTagCapability tagCapability, int x, int z) {
        this.chunkCapData = new ChunkCapData(x, z, tagCapability.getOwningColony(), tagCapability.getStaticClaimColonies());
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.chunkCapData = ChunkCapData.fromBytes(buf);
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        this.chunkCapData.toBytes(buf);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (!WorldUtil.isChunkLoaded((IWorld)world, new ChunkPos(this.chunkCapData.x, this.chunkCapData.z))) {
            ChunkClientDataHelper.addCapData(this.chunkCapData);
            return;
        }
        Chunk chunk = world.func_212866_a_(this.chunkCapData.x, this.chunkCapData.z);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null);
        if (cap != null && cap.getOwningColony() != this.chunkCapData.owningColony) {
            ChunkClientDataHelper.applyCap(this.chunkCapData, chunk);
        }
    }
}

